package gov.va.vamf.scheduling.varutility.config;

import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import javax.net.ssl.SSLSocketFactory;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.mongodb.config.AbstractMongoConfiguration;
import org.springframework.data.mongodb.repository.config.EnableMongoRepositories;

import com.mongodb.Mongo;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoClientOptions.Builder;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import com.mongodb.WriteConcern;

@Configuration()
@EnableMongoRepositories(basePackages = "gov.va.vamf.scheduling.varutility.datalayer")
public class ApplicationMongoConfig extends AbstractMongoConfiguration {
	@Value("${mongo.host}")
	private String[] hosts;
	@Value("${mongo.user}")
	private String user;
	@Value("${mongo.secretkey}")
	private String secretkey;
	@Value("${mongo.database.name}")
	private String databaseName;
	@Value("${mongo.ssl}")
	private String ssl;

	@Override
	protected String getDatabaseName() {
		return databaseName;
	}

	@Override
	public Mongo mongo() throws Exception {
		Builder builder = MongoClientOptions.builder();
		if(ssl != null && Boolean.parseBoolean(ssl)){
			builder.socketFactory(SSLSocketFactory.getDefault());
		}
		builder.writeConcern(WriteConcern.ACKNOWLEDGED);

		MongoClientOptions clientOptions = builder.build();

		MongoCredential credential = MongoCredential.createCredential(user, databaseName, secretkey.toCharArray());
		Mongo mongo = new MongoClient(getServerAddress(), Arrays.asList(credential), clientOptions);

		return mongo;
	}

	private List<ServerAddress> getServerAddress() throws UnknownHostException {
		List<ServerAddress> servers = new ArrayList<ServerAddress>();
		for (int i = 0; i < hosts.length; i++) {
			if(hosts[i].contains(":")){
				String[] hostTokens = hosts[i].split(":");
				servers.add(new ServerAddress(hostTokens[0], Integer.parseInt(hostTokens[1])));
			}
		}
		return servers;
	}
}
